import json


def create_frame_json(folder_anim, frame_move, frame_number):
    frame_data = {"credit": "Made By Toxicisity", "parent": "item/generated",
        "textures": {"layer0": f"item/entity/animation/{folder_anim}/{frame_move}{frame_number}"}
    }
    return frame_data

def save_frames(folder_anim,frame_move,frames):
    for i in range(1, frames + 1):
        frame_data = create_frame_json(folder_anim, frame_move, i)
        file_name = f"{frame_move}{i}.json"
        
        with open(file_name, 'w') as json_file:
            json.dump(frame_data, json_file, indent=4)
        print(f"Saved {file_name}")

if __name__ == "__main__":
    
    frames = 31  # Set this to the number of frames thats going to be used
    folder_anim = "staruin"
    frame_moves = ["staruin"]
    
    for i in frame_moves:
        save_frames(folder_anim, i, frames)